import { Body, Controller, Delete, Get, Param, Patch, Post, Query, UseGuards } from '@nestjs/common';
import { JwtAuthGuard } from '../auth/jwt-auth.guard';
import { VesselsService } from './vessels.service';

@Controller('vessels')
@UseGuards(JwtAuthGuard)
export class VesselsController {
  constructor(private readonly vesselsService: VesselsService) {}

  @Get()
  getVessels(@Query() _filters: any) {
    return this.vesselsService.findAll();
  }

  @Get(':id')
  getVessel(@Param('id') id: string) {
    return this.vesselsService.findOne(id);
  }

  @Post()
  create(@Body() body: any) {
    return this.vesselsService.create(body);
  }

  @Patch(':id')
  update(@Param('id') id: string, @Body() body: any) {
    return this.vesselsService.update(id, body);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.vesselsService.remove(id);
  }
}


