import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ProfileController } from './profile.controller';
import { ProfileService } from './profile.service';
import { ProfileEntity } from './profile.entity';
import { UserEntity } from '../users/user.entity';
import { ConnectionEntity } from '../network/connection.entity';
import { FollowerEntity } from '../network/follower.entity';
import { PostEntity } from '../posts/post.entity';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      ProfileEntity,
      UserEntity,
      ConnectionEntity,
      FollowerEntity,
      PostEntity
    ])
  ],
  controllers: [ProfileController],
  providers: [ProfileService],
  exports: [ProfileService]
})
export class ProfileModule {}


