import { Column, CreateDateColumn, Entity, JoinColumn, OneToOne, PrimaryGeneratedColumn, UpdateDateColumn } from 'typeorm';
import { UserEntity } from '../users/user.entity';

@Entity('profiles')
export class ProfileEntity {
  @PrimaryGeneratedColumn('uuid')
  id!: string;

  @OneToOne(() => UserEntity, user => user.profile, { eager: true })
  @JoinColumn()
  user!: UserEntity;

  // Professional fields
  @Column({ nullable: true })
  currentCompany?: string;

  @Column({ nullable: true })
  currentRole?: string;

  @Column('simple-array', { nullable: true })
  certifications?: string[];

  @Column('simple-array', { nullable: true })
  skills?: string[];

  @Column({ type: 'text', nullable: true })
  experience?: string;

  // Company fields
  @Column({ nullable: true })
  companyName?: string;

  @Column({ type: 'int', nullable: true })
  numberOfEmployees?: number;

  @Column({ type: 'text', nullable: true })
  about?: string;

  @Column({ type: 'json', nullable: true })
  contactDetails?: {
    phone?: string;
    address?: string;
    website?: string;
  };

  @CreateDateColumn()
  createdAt!: Date;

  @UpdateDateColumn()
  updatedAt!: Date;
}


