import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { PostEntity } from './post.entity';
import { LikesEntity } from './likes.entity';
import { CommentsEntity } from './comments.entity';
import { PostsService } from './posts.service';
import { PostsController } from './posts.controller';
import {MulterModule} from '@nestjs/platform-express'

@Module({
  imports: [TypeOrmModule.forFeature([PostEntity, LikesEntity, CommentsEntity]), MulterModule.register({
    dest: '../../uploads'
  })],
  providers: [PostsService],
  controllers: [PostsController],
  exports: [PostsService]
})
export class PostsModule {}


