import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from "typeorm";
import { UserEntity } from "../users/user.entity";
import { CommentsEntity } from "./comments.entity";
import { LikesEntity } from "./likes.entity";

@Entity("posts")
export class PostEntity {
  @PrimaryGeneratedColumn("uuid")
  id!: string;

  @Column({ type: "text" })
  content!: string;

  @Column({ type: "varchar", nullable: true })
  imageUrl?: string;

  // Each post belongs to one user
  @ManyToOne(() => UserEntity, user => user.posts, { eager: true })
  author!: UserEntity;

  // A post can have many comments
  @OneToMany(() => CommentsEntity, (comment) => comment.post, { cascade: true })
  comments?: CommentsEntity[];

  // A post can have many likes
  @OneToMany(() => LikesEntity, (like) => like.post, { cascade: true })
  likes?: LikesEntity[];

  @CreateDateColumn()
  createdAt!: Date;

  @UpdateDateColumn()
  updatedAt!: Date;
}
