import { Entity, PrimaryGeneratedColumn, ManyToOne, CreateDateColumn } from 'typeorm';
import { UserEntity } from '../users/user.entity';
import { PostEntity } from './post.entity';

@Entity('likes')
export class LikesEntity {
  @PrimaryGeneratedColumn('uuid') id!: string;

  @ManyToOne(() => UserEntity, { eager: true, onDelete: 'CASCADE' })
  user!: UserEntity;

  @ManyToOne(() => PostEntity, (post) => post.likes, { onDelete: 'CASCADE' })
  post!: PostEntity;

  @CreateDateColumn() createdAt!: Date;
}