import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { NewsEntity } from './news.entity';

@Injectable()
export class NewsService {
  constructor(@InjectRepository(NewsEntity) private readonly repo: Repository<NewsEntity>) {}

  findAll() {
    return this.repo.find({ order: { publishedDate: 'DESC' } });
  }
  findOne(id: string) {
    return this.repo.findOne({ where: { id } });
  }
  create(data: Partial<NewsEntity>) {
    return this.repo.save(this.repo.create(data));
  }
  async update(id: string, data: Partial<NewsEntity>) {
    await this.repo.update(id, data);
    return this.findOne(id);
  }
  remove(id: string) {
    return this.repo.delete(id);
  }
}


