import { Column, CreateDateColumn, Entity, ManyToOne, OneToMany, PrimaryGeneratedColumn, UpdateDateColumn } from 'typeorm';
import { UserEntity } from '../users/user.entity';
import { ApplicationEntity } from './application.entity';

@Entity('jobs')
export class JobEntity {
  @PrimaryGeneratedColumn('uuid')
  id!: string;

  @Column()
  title!: string;

  @Column({ type: 'text' })
  description!: string;

  @Column()
  location!: string;

  @Column({ nullable: true })
  salaryRange?: string;

  @Column({ type: 'decimal', precision: 10, scale: 2, nullable: true })
  minSalary?: number;

  @Column({ type: 'decimal', precision: 10, scale: 2, nullable: true })
  maxSalary?: number;

  @Column({ 
    type: 'enum', 
    enum: [
      // Major Global Currencies
      'USD', 'EUR', 'GBP', 'JPY', 'CHF',
      // North American Currencies
      'CAD', 'MXN',
      // Oceania Currencies
      'AUD', 'NZD',
      // Nordic Currencies
      'SEK', 'NOK', 'DKK',
      // African Currencies
      'ZAR', 'NGN', 'EGP', 'KES', 'GHS', 'MAD', 'TND', 'ETB', 'UGX', 'TZS', 'BWP', 'MUR', 'XOF', 'XAF',
      // Asian Currencies
      'CNY', 'INR', 'KRW', 'SGD', 'HKD', 'THB', 'MYR', 'IDR', 'PHP', 'VND',
      // Middle Eastern Currencies
      'AED', 'SAR', 'QAR', 'KWD', 'BHD', 'OMR', 'ILS', 'TRY',
      // South American Currencies
      'BRL', 'ARS', 'CLP', 'COP', 'PEN',
      // Eastern European Currencies
      'PLN', 'CZK', 'HUF', 'RON', 'RUB', 'UAH'
    ],
    nullable: true 
  })
  currency?: string;

  @Column({ 
    type: 'enum', 
    enum: ['hourly', 'daily', 'weekly', 'monthly', 'annually'],
    nullable: true 
  })
  salaryDuration?: string;

  @Column({ type: 'enum', enum: ['full-time', 'part-time', 'contract', 'internship'] })
  jobType!: string;

  @Column({ type: 'text' })
  requirements!: string;

  @ManyToOne(() => UserEntity, { eager: true })
  company!: UserEntity;

  @OneToMany(() => ApplicationEntity, app => app.job)
  applications?: ApplicationEntity[];

  @Column({ default: true })
  isActive!: boolean;

  @CreateDateColumn()
  postedDate!: Date;

  @UpdateDateColumn()
  updatedAt!: Date;
}


