import { registerDecorator, ValidationOptions, ValidationArguments } from 'class-validator';

export function IsSalaryRangeValid(validationOptions?: ValidationOptions) {
  return function (object: Object, propertyName: string) {
    registerDecorator({
      name: 'isSalaryRangeValid',
      target: object.constructor,
      propertyName: propertyName,
      options: validationOptions,
      validator: {
        validate(value: any, args: ValidationArguments) {
          const obj = args.object as any;
          const minSalary = obj.minSalary;
          const maxSalary = obj.maxSalary;
          
          // If both values are provided, min should be <= max
          if (minSalary !== undefined && maxSalary !== undefined) {
            return minSalary <= maxSalary;
          }
          
          // If only one or neither is provided, it's valid
          return true;
        },
        defaultMessage(args: ValidationArguments) {
          return 'Maximum salary must be greater than or equal to minimum salary';
        },
      },
    });
  };
}