import { IsString, IsNotEmpty, IsOptional, IsBoolean, IsEnum, IsNumber, Min } from 'class-validator';
import { IsSalaryRangeValid } from './salary-range.validator';

export class CreateJobDto {
  @IsString()
  @IsNotEmpty()
  title!: string;

  @IsString()
  @IsNotEmpty()
  description!: string;

  @IsString()
  @IsNotEmpty()
  location!: string;

  @IsString()
  @IsOptional()
  salary?: string;

  @IsOptional()
  @IsNumber()
  @Min(0)
  minSalary?: number;

  @IsOptional()
  @IsNumber()
  @Min(0)
  @IsSalaryRangeValid()
  maxSalary?: number;

  @IsOptional()
  @IsEnum([
    // Major Global Currencies
    'USD', 'EUR', 'GBP', 'JPY', 'CHF',
    // North American Currencies
    'CAD', 'MXN',
    // Oceania Currencies
    'AUD', 'NZD',
    // Nordic Currencies
    'SEK', 'NOK', 'DKK',
    // African Currencies
    'ZAR', 'NGN', 'EGP', 'KES', 'GHS', 'MAD', 'TND', 'ETB', 'UGX', 'TZS', 'BWP', 'MUR', 'XOF', 'XAF',
    // Asian Currencies
    'CNY', 'INR', 'KRW', 'SGD', 'HKD', 'THB', 'MYR', 'IDR', 'PHP', 'VND',
    // Middle Eastern Currencies
    'AED', 'SAR', 'QAR', 'KWD', 'BHD', 'OMR', 'ILS', 'TRY',
    // South American Currencies
    'BRL', 'ARS', 'CLP', 'COP', 'PEN',
    // Eastern European Currencies
    'PLN', 'CZK', 'HUF', 'RON', 'RUB', 'UAH'
  ])
  currency?: string;

  @IsOptional()
  @IsEnum(['hourly', 'daily', 'weekly', 'monthly', 'annually'])
  salaryDuration?: string;

  @IsString()
  @IsNotEmpty()
  jobType!: string;

  @IsString()
  @IsOptional()
  requirements?: string;

  @IsString()
  @IsOptional()
  company?: string;

  @IsBoolean()
  @IsOptional()
  isActive?: boolean;
}
