import { Column, CreateDateColumn, Entity, ManyToOne, PrimaryGeneratedColumn, UpdateDateColumn } from 'typeorm';
import { JobEntity } from './job.entity';
import { UserEntity } from '../users/user.entity';

@Entity('applications')
export class ApplicationEntity {
  @PrimaryGeneratedColumn('uuid')
  id!: string;

  @ManyToOne(() => JobEntity, job => job.applications)
  job!: JobEntity;

  @ManyToOne(() => UserEntity, { eager: true })
  applicant!: UserEntity;

  @Column()
  cvUrl!: string;

  @Column({ type: 'text', nullable: true })
  coverLetter?: string;

  @Column({ 
    type: 'enum', 
    enum: ['pending', 'reviewed', 'accepted', 'rejected'],
    default: 'pending'
  })
  status!: 'pending' | 'reviewed' | 'accepted' | 'rejected';

  @CreateDateColumn()
  appliedDate!: Date;

  @UpdateDateColumn()
  updatedAt!: Date;
}
