import { Controller, Get, UseGuards } from '@nestjs/common';
import { JwtAuthGuard } from '../auth/jwt-auth.guard';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { ConnectionEntity } from '../network/connection.entity';
import { JobEntity } from '../jobs/job.entity';
import { VesselEntity } from '../vessels/vessel.entity';
import { MessageEntity } from '../messages/message.entity';
import { PostEntity } from '../posts/post.entity';

@Controller('dashboard')
@UseGuards(JwtAuthGuard)
export class DashboardController {
  constructor(
    @InjectRepository(ConnectionEntity) private readonly connections: Repository<ConnectionEntity>,
    @InjectRepository(JobEntity) private readonly jobs: Repository<JobEntity>,
    @InjectRepository(VesselEntity) private readonly vessels: Repository<VesselEntity>,
    @InjectRepository(MessageEntity) private readonly messages: Repository<MessageEntity>,
    @InjectRepository(PostEntity) private readonly posts: Repository<PostEntity>
  ) {}

  @Get()
  async getDashboardData() {
    const [connections, jobs, vessels, messages] = await Promise.all([
      this.connections.count(),
      this.jobs.count(),
      this.vessels.count(),
      this.messages.count()
    ]);

    const feed = await this.posts.find({ order: { createdAt: 'DESC' }, take: 10 });

    return {
      stats: { connections, jobs, vessels, messages },
      feed
    };
  }
}


