import { Injectable, CanActivate, ExecutionContext, ForbiddenException } from '@nestjs/common';
import { Reflector } from '@nestjs/core';

@Injectable()
export class UserTypeGuard implements CanActivate {
  constructor(private reflector: Reflector) {}

  canActivate(context: ExecutionContext): boolean {
    const requiredUserTypes = this.reflector.get<string[]>('userTypes', context.getHandler());
    
    if (!requiredUserTypes) {
      return true;
    }

    const request = context.switchToHttp().getRequest();
    const user = request.user;

    if (!user || !requiredUserTypes.includes(user.userType)) {
      throw new ForbiddenException('Access denied. Insufficient permissions.');
    }

    return true;
  }
}
