import { request } from 'node:https';
import { store } from '../store/store.js';
import { EmailJSResponseStatus } from '../models/EmailJSResponseStatus.js';
export const sendPost = (data) => {
    const options = {
        host: store.origin,
        path: '/api/v1.0/email/send',
        port: 443,
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
    };
    return new Promise((resolve, reject) => {
        const req = request(options, (res) => {
            const chunks = [];
            res.on('data', (chunk) => chunks.push(chunk));
            res.on('end', () => {
                const message = Buffer.concat(chunks).toString();
                const responseStatus = new EmailJSResponseStatus(res.statusCode, message);
                if (res.statusCode === 200) {
                    resolve(responseStatus);
                }
                else {
                    reject(responseStatus);
                }
            });
            res.on('error', (error) => {
                reject(error);
            });
        });
        req.on('error', (error) => {
            reject(error);
        });
        if (data) {
            req.write(data);
        }
        req.end();
    });
};
