"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isBlockedValueInParams = void 0;
const validateBlockListParams_js_1 = require("../validateBlockListParams/validateBlockListParams.js");
const isBlockListDisabled = (options) => {
    var _a;
    return !((_a = options.list) === null || _a === void 0 ? void 0 : _a.length) || !options.watchVariable;
};
const getValue = (data, name) => {
    return data instanceof FormData ? data.get(name) : data[name];
};
const isBlockedValueInParams = (options, params) => {
    if (isBlockListDisabled(options))
        return false;
    (0, validateBlockListParams_js_1.validateBlockListParams)(options.list, options.watchVariable);
    const value = getValue(params, options.watchVariable);
    if (typeof value !== 'string')
        return false;
    return options.list.includes(value);
};
exports.isBlockedValueInParams = isBlockedValueInParams;
