"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMemoryStorage = void 0;
class MemoryStorage {
    constructor() {
        this.store = {};
    }
    get(key) {
        return this.store[key];
    }
    set(key, value) {
        this.store[key] = value;
    }
    remove(key) {
        delete this.store[key];
    }
}
const createMemoryStorage = () => {
    const memoryStorage = new MemoryStorage();
    return {
        get: (key) => Promise.resolve(memoryStorage.get(key)),
        set: (key, value) => Promise.resolve(memoryStorage.set(key, value)),
        remove: (key) => Promise.resolve(memoryStorage.remove(key)),
    };
};
exports.createMemoryStorage = createMemoryStorage;
