import { MigrationInterface, QueryRunner } from "typeorm";

export class UpdateCurrencyEnum1700000001000 implements MigrationInterface {
    name = 'UpdateCurrencyEnum1700000001000'

    public async up(queryRunner: QueryRunner): Promise<void> {
        // Check if the currency enum exists first
        const enumExists = await queryRunner.query(`
            SELECT 1 FROM pg_type WHERE typname = 'jobs_currency_enum'
        `);
        
        if (enumExists.length > 0) {
            // Update existing enum
            await queryRunner.query(`
                ALTER TYPE "jobs_currency_enum" RENAME TO "jobs_currency_enum_old";
                CREATE TYPE "jobs_currency_enum" AS ENUM(
                    'USD', 'EUR', 'GBP', 'JPY', 'CHF',
                    'CAD', 'MXN',
                    'AUD', 'NZD',
                    'SEK', 'NOK', 'DKK',
                    'ZAR', 'NGN', 'EGP', 'KES', 'GHS', 'MAD', 'TND', 'ETB', 'UGX', 'TZS', 'BWP', 'MUR', 'XOF', 'XAF',
                    'CNY', 'INR', 'KRW', 'SGD', 'HKD', 'THB', 'MYR', 'IDR', 'PHP', 'VND',
                    'AED', 'SAR', 'QAR', 'KWD', 'BHD', 'OMR', 'ILS', 'TRY',
                    'BRL', 'ARS', 'CLP', 'COP', 'PEN',
                    'PLN', 'CZK', 'HUF', 'RON', 'RUB', 'UAH'
                );
                ALTER TABLE "jobs" ALTER COLUMN "currency" TYPE "jobs_currency_enum" USING "currency"::text::"jobs_currency_enum";
                DROP TYPE "jobs_currency_enum_old";
            `);
        } else {
            // Create new enum if it doesn't exist
            await queryRunner.query(`
                CREATE TYPE "jobs_currency_enum" AS ENUM(
                    'USD', 'EUR', 'GBP', 'JPY', 'CHF',
                    'CAD', 'MXN',
                    'AUD', 'NZD',
                    'SEK', 'NOK', 'DKK',
                    'ZAR', 'NGN', 'EGP', 'KES', 'GHS', 'MAD', 'TND', 'ETB', 'UGX', 'TZS', 'BWP', 'MUR', 'XOF', 'XAF',
                    'CNY', 'INR', 'KRW', 'SGD', 'HKD', 'THB', 'MYR', 'IDR', 'PHP', 'VND',
                    'AED', 'SAR', 'QAR', 'KWD', 'BHD', 'OMR', 'ILS', 'TRY',
                    'BRL', 'ARS', 'CLP', 'COP', 'PEN',
                    'PLN', 'CZK', 'HUF', 'RON', 'RUB', 'UAH'
                );
            `);
        }
    }

    public async down(queryRunner: QueryRunner): Promise<void> {
        // Revert back to the original enum
        await queryRunner.query(`
            ALTER TYPE "jobs_currency_enum" RENAME TO "jobs_currency_enum_new";
            CREATE TYPE "jobs_currency_enum" AS ENUM('USD', 'EUR', 'GBP', 'CAD', 'AUD', 'JPY', 'CHF', 'SEK', 'NOK', 'DKK');
            ALTER TABLE "jobs" ALTER COLUMN "currency" TYPE "jobs_currency_enum" USING "currency"::text::"jobs_currency_enum";
            DROP TYPE "jobs_currency_enum_new";
        `);
    }
}