import { MigrationInterface, QueryRunner, TableColumn } from 'typeorm';

export class AddSalaryFields1700000000000 implements MigrationInterface {
  name = 'AddSalaryFields1700000000000';

  public async up(queryRunner: QueryRunner): Promise<void> {
    // Make salaryRange nullable to preserve existing data
    await queryRunner.changeColumn(
      'jobs',
      'salaryRange',
      new TableColumn({
        name: 'salaryRange',
        type: 'varchar',
        isNullable: true,
      })
    );

    // Add new salary fields
    await queryRunner.addColumn(
      'jobs',
      new TableColumn({
        name: 'minSalary',
        type: 'decimal',
        precision: 10,
        scale: 2,
        isNullable: true,
      })
    );

    await queryRunner.addColumn(
      'jobs',
      new TableColumn({
        name: 'maxSalary',
        type: 'decimal',
        precision: 10,
        scale: 2,
        isNullable: true,
      })
    );

    await queryRunner.addColumn(
      'jobs',
      new TableColumn({
        name: 'currency',
        type: 'enum',
        enum: ['USD', 'EUR', 'GBP', 'CAD', 'AUD', 'JPY', 'CHF', 'SEK', 'NOK', 'DKK'],
        isNullable: true,
      })
    );

    await queryRunner.addColumn(
      'jobs',
      new TableColumn({
        name: 'salaryDuration',
        type: 'enum',
        enum: ['hourly', 'daily', 'weekly', 'monthly', 'annually'],
        isNullable: true,
      })
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    // Remove new salary fields
    await queryRunner.dropColumn('jobs', 'salaryDuration');
    await queryRunner.dropColumn('jobs', 'currency');
    await queryRunner.dropColumn('jobs', 'maxSalary');
    await queryRunner.dropColumn('jobs', 'minSalary');

    // Restore salaryRange as non-nullable
    await queryRunner.changeColumn(
      'jobs',
      'salaryRange',
      new TableColumn({
        name: 'salaryRange',
        type: 'varchar',
        isNullable: false,
      })
    );
  }
}