"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const user_entity_1 = require("./user.entity");
let UsersService = class UsersService {
    constructor(usersRepo) {
        this.usersRepo = usersRepo;
    }
    findByEmail(email) {
        return this.usersRepo.findOne({
            where: { email },
            select: [
                'id',
                'email',
                'name',
                'userType',
                'passwordHash',
                'isEmailVerified',
                'emailVerificationToken',
                'emailVerificationExpires',
                'passwordResetToken',
                'passwordResetExpires'
            ]
        });
    }
    findById(id) {
        return this.usersRepo.findOne({ where: { id } });
    }
    async createUser(params) {
        const user = this.usersRepo.create({
            email: params.email,
            name: params.name || params.email.split('@')[0],
            passwordHash: params.passwordHash,
            userType: params.userType || 'professional',
            isEmailVerified: params.isEmailVerified || false,
            emailVerificationToken: params.emailVerificationToken,
            emailVerificationExpires: params.emailVerificationExpires
        });
        return this.usersRepo.save(user);
    }
    async updateUser(id, updates) {
        await this.usersRepo.update(id, updates);
        return this.findById(id);
    }
    async searchByName(searchTerm) {
        return this.usersRepo
            .createQueryBuilder('user')
            .where('LOWER(user.name) LIKE LOWER(:searchTerm)', { searchTerm: `%${searchTerm}%` })
            .select(['user.id', 'user.name', 'user.email', 'user.userType', 'user.avatarUrl'])
            .limit(20)
            .getMany();
    }
    async searchCompanies(searchTerm) {
        return this.usersRepo
            .createQueryBuilder('user')
            .where('user.userType = :userType', { userType: 'company' })
            .andWhere('LOWER(user.name) LIKE LOWER(:searchTerm)', { searchTerm: `%${searchTerm}%` })
            .select(['user.id', 'user.name', 'user.email', 'user.userType', 'user.avatarUrl'])
            .limit(10)
            .getMany();
    }
};
exports.UsersService = UsersService;
exports.UsersService = UsersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.UserEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], UsersService);
//# sourceMappingURL=users.service.js.map