import { Repository } from 'typeorm';
import { UserEntity } from './user.entity';
export declare class UsersService {
    private readonly usersRepo;
    constructor(usersRepo: Repository<UserEntity>);
    findByEmail(email: string): Promise<UserEntity | null>;
    findById(id: string): Promise<UserEntity | null>;
    createUser(params: {
        email: string;
        name?: string;
        passwordHash: string;
        userType?: 'professional' | 'company';
        isEmailVerified?: boolean;
        emailVerificationToken?: string;
        emailVerificationExpires?: Date;
    }): Promise<UserEntity>;
    updateUser(id: string, updates: Partial<UserEntity>): Promise<UserEntity | null>;
    searchByName(searchTerm: string): Promise<UserEntity[]>;
    searchCompanies(searchTerm: string): Promise<UserEntity[]>;
}
