import { Repository } from 'typeorm';
import { PostEntity } from './post.entity';
import { LikesEntity } from './likes.entity';
import { CommentsEntity } from './comments.entity';
export declare class PostsService {
    private readonly postRepo;
    private readonly likeRepo;
    private readonly commentRepo;
    constructor(postRepo: Repository<PostEntity>, likeRepo: Repository<LikesEntity>, commentRepo: Repository<CommentsEntity>);
    findAll(): Promise<PostEntity[]>;
    getFeed(userId: string, followedUserIds?: string[]): Promise<PostEntity[]>;
    findOne(id: string): Promise<PostEntity>;
    create(data: Partial<PostEntity>): Promise<PostEntity>;
    createWithImage(data: Partial<PostEntity>, imageUrl?: string): Promise<PostEntity | null>;
    verifyPostOwnership(postId: string, userId: string): Promise<PostEntity>;
    update(id: string, data: Partial<PostEntity>, userId?: string): Promise<PostEntity>;
    remove(id: string): Promise<import("typeorm").DeleteResult>;
    getLikesByPost(postId: string): Promise<LikesEntity[]>;
    addLike(postId: string, userId: string): Promise<LikesEntity | {
        message: string;
        likeId: string;
    }>;
    removeLike(postId: string, userId: string): Promise<{
        message: string;
    }>;
    addComment(postId: string, userId: string, content: string): Promise<CommentsEntity>;
    updateComment(commentId: string, userId: string, content: string): Promise<{
        message: string;
        comment: CommentsEntity;
    }>;
    deleteComment(commentId: string, userId: string): Promise<{
        message: string;
    }>;
    getCommentsByPost(postId: string): Promise<CommentsEntity[]>;
}
