"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkController = void 0;
const common_1 = require("@nestjs/common");
const jwt_auth_guard_1 = require("../auth/jwt-auth.guard");
const network_service_1 = require("./network.service");
let NetworkController = class NetworkController {
    constructor(networkService) {
        this.networkService = networkService;
    }
    getConnections(req) {
        return this.networkService.getConnections(req.user.userId);
    }
    getSentRequests(req) {
        return this.networkService.getSentRequests(req.user.userId);
    }
    getReceivedRequests(req) {
        return this.networkService.getReceivedRequests(req.user.userId);
    }
    sendConnectionRequest(req, targetUserId) {
        return this.networkService.sendConnectionRequest(req.user.userId, targetUserId);
    }
    acceptConnection(req, requestId) {
        return this.networkService.acceptConnection(requestId, req.user.userId);
    }
    rejectConnection(req, requestId) {
        return this.networkService.rejectConnection(requestId, req.user.userId);
    }
    removeConnection(connectionId) {
        return this.networkService.removeConnection(connectionId);
    }
    followUser(req, targetUserId) {
        return this.networkService.followUser(req.user.userId, targetUserId);
    }
    unfollowUser(req, targetUserId) {
        return this.networkService.unfollowUser(req.user.userId, targetUserId);
    }
    getFollowers(userId) {
        return this.networkService.getFollowers(userId);
    }
    getFollowing(userId) {
        return this.networkService.getFollowing(userId);
    }
};
exports.NetworkController = NetworkController;
__decorate([
    (0, common_1.Get)('connections'),
    __param(0, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NetworkController.prototype, "getConnections", null);
__decorate([
    (0, common_1.Get)('requests/sent'),
    __param(0, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NetworkController.prototype, "getSentRequests", null);
__decorate([
    (0, common_1.Get)('requests/received'),
    __param(0, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NetworkController.prototype, "getReceivedRequests", null);
__decorate([
    (0, common_1.Post)('connect/:userId'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)('userId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], NetworkController.prototype, "sendConnectionRequest", null);
__decorate([
    (0, common_1.Patch)('requests/:id/accept'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], NetworkController.prototype, "acceptConnection", null);
__decorate([
    (0, common_1.Patch)('requests/:id/reject'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], NetworkController.prototype, "rejectConnection", null);
__decorate([
    (0, common_1.Delete)('connections/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], NetworkController.prototype, "removeConnection", null);
__decorate([
    (0, common_1.Post)('follow/:userId'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)('userId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], NetworkController.prototype, "followUser", null);
__decorate([
    (0, common_1.Delete)('follow/:userId'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)('userId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], NetworkController.prototype, "unfollowUser", null);
__decorate([
    (0, common_1.Get)('followers/:userId'),
    __param(0, (0, common_1.Param)('userId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], NetworkController.prototype, "getFollowers", null);
__decorate([
    (0, common_1.Get)('following/:userId'),
    __param(0, (0, common_1.Param)('userId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], NetworkController.prototype, "getFollowing", null);
exports.NetworkController = NetworkController = __decorate([
    (0, common_1.Controller)('network'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __metadata("design:paramtypes", [network_service_1.NetworkService])
], NetworkController);
//# sourceMappingURL=network.controller.js.map