import { Repository } from 'typeorm';
import { MessageEntity } from './message.entity';
import { ConnectionEntity } from '../network/connection.entity';
export declare class MessagesService {
    private readonly messageRepo;
    private readonly connectionRepo;
    constructor(messageRepo: Repository<MessageEntity>, connectionRepo: Repository<ConnectionEntity>);
    checkConnection(userId: string, otherUserId: string): Promise<boolean>;
    sendMessage(senderId: string, recipientId: string, content: string): Promise<MessageEntity>;
    getConversation(userId: string, otherUserId: string): Promise<MessageEntity[]>;
    getConversations(userId: string): Promise<any[]>;
    markAsRead(messageId: string, userId: string): Promise<MessageEntity>;
    markConversationAsRead(userId: string, otherUserId: string): Promise<{
        success: boolean;
    }>;
}
