"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const job_entity_1 = require("./job.entity");
const application_entity_1 = require("./application.entity");
const user_entity_1 = require("../users/user.entity");
let JobsService = class JobsService {
    constructor(jobRepo, applicationRepo, userRepo) {
        this.jobRepo = jobRepo;
        this.applicationRepo = applicationRepo;
        this.userRepo = userRepo;
    }
    async findAll(filters) {
        const queryBuilder = this.jobRepo.createQueryBuilder('job')
            .leftJoinAndSelect('job.company', 'company')
            .leftJoinAndSelect('job.applications', 'applications')
            .where('job.isActive = :isActive', { isActive: true });
        if (filters === null || filters === void 0 ? void 0 : filters.search) {
            queryBuilder.andWhere('(LOWER(job.title) LIKE LOWER(:search) OR LOWER(job.description) LIKE LOWER(:search) OR LOWER(company.name) LIKE LOWER(:search))', { search: `%${filters.search}%` });
        }
        if (filters === null || filters === void 0 ? void 0 : filters.location) {
            queryBuilder.andWhere('LOWER(job.location) LIKE LOWER(:location)', {
                location: `%${filters.location}%`
            });
        }
        if (filters === null || filters === void 0 ? void 0 : filters.jobType) {
            queryBuilder.andWhere('job.jobType = :jobType', { jobType: filters.jobType });
        }
        if (filters === null || filters === void 0 ? void 0 : filters.companyId) {
            queryBuilder.andWhere('company.id = :companyId', { companyId: filters.companyId });
        }
        const jobs = await queryBuilder
            .orderBy('job.postedDate', 'DESC')
            .getMany();
        return jobs.map(job => this.formatJobResponse(job));
    }
    async findOne(id) {
        const job = await this.jobRepo.findOne({ where: { id }, relations: ['company', 'applications'] });
        return job ? this.formatJobResponse(job) : null;
    }
    async create(dto, companyId) {
        var _a;
        try {
            if (!dto.title || !dto.description || !dto.location) {
                throw new common_1.BadRequestException({
                    message: 'Validation failed',
                    errors: {
                        title: !dto.title ? 'Title is required' : undefined,
                        description: !dto.description ? 'Description is required' : undefined,
                        location: !dto.location ? 'Location is required' : undefined,
                    }
                });
            }
            if (dto.minSalary !== undefined && dto.maxSalary !== undefined && dto.minSalary > dto.maxSalary) {
                throw new common_1.BadRequestException({
                    message: 'Validation failed',
                    errors: {
                        salary: 'Minimum salary cannot be greater than maximum salary'
                    }
                });
            }
            const validJobTypes = ['full-time', 'part-time', 'contract', 'internship'];
            const normalizedJobType = (_a = dto.jobType) === null || _a === void 0 ? void 0 : _a.toLowerCase();
            if (!normalizedJobType || !validJobTypes.includes(normalizedJobType)) {
                throw new common_1.BadRequestException({
                    message: 'Validation failed',
                    errors: {
                        jobType: `Job type must be one of: ${validJobTypes.join(', ')}`
                    }
                });
            }
            const company = await this.userRepo.findOne({ where: { id: companyId } });
            if (!company) {
                throw new common_1.NotFoundException('Company not found');
            }
            const jobEntity = this.jobRepo.create({
                title: dto.title,
                description: dto.description,
                location: dto.location,
                minSalary: dto.minSalary,
                maxSalary: dto.maxSalary,
                currency: dto.currency,
                salaryDuration: dto.salaryDuration,
                salaryRange: dto.salary || this.formatSalaryDisplay(dto.minSalary, dto.maxSalary, dto.currency, dto.salaryDuration) || 'Not specified',
                jobType: normalizedJobType,
                requirements: dto.requirements || '',
                company: company,
                isActive: dto.isActive !== undefined ? dto.isActive : true,
            });
            const savedJob = await this.jobRepo.save(jobEntity);
            const job = await this.jobRepo.findOne({
                where: { id: savedJob.id },
                relations: ['company']
            });
            return this.formatJobResponse(job);
        }
        catch (error) {
            if (error instanceof common_1.BadRequestException || error instanceof common_1.NotFoundException) {
                throw error;
            }
            throw new common_1.InternalServerErrorException({
                message: 'Failed to create job',
                error: error instanceof Error ? error.message : 'Unknown error'
            });
        }
    }
    async update(id, updateJobDto) {
        if (updateJobDto.minSalary !== undefined && updateJobDto.maxSalary !== undefined && updateJobDto.minSalary > updateJobDto.maxSalary) {
            throw new common_1.BadRequestException({
                message: 'Validation failed',
                errors: {
                    salary: 'Minimum salary cannot be greater than maximum salary'
                }
            });
        }
        const { company, salary, ...dtoData } = updateJobDto;
        const updateData = {
            ...dtoData
        };
        if (salary !== undefined) {
            updateData.salaryRange = salary;
        }
        else if (updateJobDto.minSalary !== undefined || updateJobDto.maxSalary !== undefined ||
            updateJobDto.currency !== undefined || updateJobDto.salaryDuration !== undefined) {
            const currentJob = await this.findOne(id);
            if (currentJob) {
                const newMinSalary = updateJobDto.minSalary !== undefined ? updateJobDto.minSalary : currentJob.minSalary;
                const newMaxSalary = updateJobDto.maxSalary !== undefined ? updateJobDto.maxSalary : currentJob.maxSalary;
                const newCurrency = updateJobDto.currency !== undefined ? updateJobDto.currency : currentJob.currency;
                const newDuration = updateJobDto.salaryDuration !== undefined ? updateJobDto.salaryDuration : currentJob.salaryDuration;
                updateData.salaryRange = this.formatSalaryDisplay(newMinSalary, newMaxSalary, newCurrency, newDuration) || 'Not specified';
            }
        }
        if (company) {
            const companyEntity = await this.userRepo.findOne({ where: { id: company } });
            if (companyEntity) {
                updateData.company = companyEntity;
            }
        }
        await this.jobRepo.update(id, updateData);
        const updatedJob = await this.findOne(id);
        return this.formatJobResponse(updatedJob);
    }
    remove(id) {
        return this.jobRepo.delete(id);
    }
    async applyToJob(jobId, applicantId, cvUrl, coverLetter) {
        const job = await this.findOne(jobId);
        if (!job) {
            throw new common_1.NotFoundException('Job not found');
        }
        const existingApplication = await this.applicationRepo.findOne({
            where: {
                job: { id: jobId },
                applicant: { id: applicantId }
            }
        });
        if (existingApplication) {
            throw new common_1.BadRequestException('Already applied to this job');
        }
        const application = this.applicationRepo.create({
            job: { id: jobId },
            applicant: { id: applicantId },
            cvUrl,
            coverLetter,
            status: 'pending'
        });
        return this.applicationRepo.save(application);
    }
    async getUserApplications(userId) {
        return this.applicationRepo.find({
            where: { applicant: { id: userId } },
            relations: ['job'],
            order: { appliedDate: 'DESC' }
        });
    }
    async getJobApplications(jobId) {
        return this.applicationRepo.find({
            where: { job: { id: jobId } },
            order: { appliedDate: 'DESC' }
        });
    }
    async updateApplicationStatus(applicationId, status) {
        const application = await this.applicationRepo.findOne({
            where: { id: applicationId }
        });
        if (!application) {
            throw new common_1.NotFoundException('Application not found');
        }
        application.status = status;
        return this.applicationRepo.save(application);
    }
    formatSalaryDisplay(minSalary, maxSalary, currency, duration) {
        if (!minSalary && !maxSalary) {
            return null;
        }
        if (!currency || !duration) {
            return null;
        }
        const currencySymbols = {
            'USD': '$',
            'EUR': '€',
            'GBP': '£',
            'JPY': '¥',
            'CHF': 'CHF',
            'CAD': 'C$',
            'MXN': '$',
            'AUD': 'A$',
            'NZD': 'NZ$',
            'SEK': 'kr',
            'NOK': 'kr',
            'DKK': 'kr',
            'ZAR': 'R',
            'NGN': '₦',
            'EGP': '£',
            'KES': 'KSh',
            'GHS': '₵',
            'MAD': 'DH',
            'TND': 'د.ت',
            'ETB': 'Br',
            'UGX': 'USh',
            'TZS': 'TSh',
            'BWP': 'P',
            'MUR': '₨',
            'XOF': 'CFA',
            'XAF': 'FCFA',
            'CNY': '¥',
            'INR': '₹',
            'KRW': '₩',
            'SGD': 'S$',
            'HKD': 'HK$',
            'THB': '฿',
            'MYR': 'RM',
            'IDR': 'Rp',
            'PHP': '₱',
            'VND': '₫',
            'AED': 'د.إ',
            'SAR': '﷼',
            'QAR': '﷼',
            'KWD': 'د.ك',
            'BHD': '.د.ب',
            'OMR': '﷼',
            'ILS': '₪',
            'TRY': '₺',
            'BRL': 'R$',
            'ARS': '$',
            'CLP': '$',
            'COP': '$',
            'PEN': 'S/',
            'PLN': 'zł',
            'CZK': 'Kč',
            'HUF': 'Ft',
            'RON': 'lei',
            'RUB': '₽',
            'UAH': '₴'
        };
        const durationText = {
            'hourly': 'per hour',
            'daily': 'per day',
            'weekly': 'per week',
            'monthly': 'per month',
            'annually': 'per year'
        };
        const symbol = currencySymbols[currency] || currency;
        const durationStr = durationText[duration] || duration;
        const formatNumber = (num) => {
            if (currency === 'JPY') {
                return Math.round(num).toLocaleString();
            }
            return num.toLocaleString(undefined, { minimumFractionDigits: 0, maximumFractionDigits: 2 });
        };
        if (minSalary && maxSalary) {
            if (minSalary === maxSalary) {
                return `${symbol}${formatNumber(minSalary)} ${durationStr}`;
            }
            else {
                return `${symbol}${formatNumber(minSalary)} - ${symbol}${formatNumber(maxSalary)} ${durationStr}`;
            }
        }
        else if (minSalary) {
            return `From ${symbol}${formatNumber(minSalary)} ${durationStr}`;
        }
        else if (maxSalary) {
            return `Up to ${symbol}${formatNumber(maxSalary)} ${durationStr}`;
        }
        return null;
    }
    formatCurrency(amount, currencyCode) {
        const currencyRules = {
            'USD': { symbol: '$', decimals: 2, symbolPosition: 'before' },
            'EUR': { symbol: '€', decimals: 2, symbolPosition: 'before' },
            'GBP': { symbol: '£', decimals: 2, symbolPosition: 'before' },
            'JPY': { symbol: '¥', decimals: 0, symbolPosition: 'before' },
            'CHF': { symbol: 'CHF', decimals: 2, symbolPosition: 'before' },
            'CAD': { symbol: 'C$', decimals: 2, symbolPosition: 'before' },
            'MXN': { symbol: '$', decimals: 2, symbolPosition: 'before' },
            'AUD': { symbol: 'A$', decimals: 2, symbolPosition: 'before' },
            'NZD': { symbol: 'NZ$', decimals: 2, symbolPosition: 'before' },
            'SEK': { symbol: 'kr', decimals: 2, symbolPosition: 'after' },
            'NOK': { symbol: 'kr', decimals: 2, symbolPosition: 'after' },
            'DKK': { symbol: 'kr', decimals: 2, symbolPosition: 'after' },
            'ZAR': { symbol: 'R', decimals: 2, symbolPosition: 'before' },
            'NGN': { symbol: '₦', decimals: 2, symbolPosition: 'before' },
            'EGP': { symbol: '£', decimals: 2, symbolPosition: 'before' },
            'KES': { symbol: 'KSh', decimals: 2, symbolPosition: 'before' },
            'GHS': { symbol: '₵', decimals: 2, symbolPosition: 'before' },
            'MAD': { symbol: 'DH', decimals: 2, symbolPosition: 'after' },
            'TND': { symbol: 'د.ت', decimals: 3, symbolPosition: 'before' },
            'ETB': { symbol: 'Br', decimals: 2, symbolPosition: 'before' },
            'UGX': { symbol: 'USh', decimals: 0, symbolPosition: 'before' },
            'TZS': { symbol: 'TSh', decimals: 0, symbolPosition: 'before' },
            'BWP': { symbol: 'P', decimals: 2, symbolPosition: 'before' },
            'MUR': { symbol: '₨', decimals: 2, symbolPosition: 'before' },
            'XOF': { symbol: 'CFA', decimals: 0, symbolPosition: 'after' },
            'XAF': { symbol: 'FCFA', decimals: 0, symbolPosition: 'after' },
            'CNY': { symbol: '¥', decimals: 2, symbolPosition: 'before' },
            'INR': { symbol: '₹', decimals: 2, symbolPosition: 'before' },
            'KRW': { symbol: '₩', decimals: 0, symbolPosition: 'before' },
            'SGD': { symbol: 'S$', decimals: 2, symbolPosition: 'before' },
            'HKD': { symbol: 'HK$', decimals: 2, symbolPosition: 'before' },
            'THB': { symbol: '฿', decimals: 2, symbolPosition: 'before' },
            'MYR': { symbol: 'RM', decimals: 2, symbolPosition: 'before' },
            'IDR': { symbol: 'Rp', decimals: 0, symbolPosition: 'before' },
            'PHP': { symbol: '₱', decimals: 2, symbolPosition: 'before' },
            'VND': { symbol: '₫', decimals: 0, symbolPosition: 'after' },
            'AED': { symbol: 'د.إ', decimals: 2, symbolPosition: 'after' },
            'SAR': { symbol: '﷼', decimals: 2, symbolPosition: 'before' },
            'QAR': { symbol: '﷼', decimals: 2, symbolPosition: 'before' },
            'KWD': { symbol: 'د.ك', decimals: 3, symbolPosition: 'before' },
            'BHD': { symbol: '.د.ب', decimals: 3, symbolPosition: 'before' },
            'OMR': { symbol: '﷼', decimals: 3, symbolPosition: 'before' },
            'ILS': { symbol: '₪', decimals: 2, symbolPosition: 'before' },
            'TRY': { symbol: '₺', decimals: 2, symbolPosition: 'before' },
            'BRL': { symbol: 'R$', decimals: 2, symbolPosition: 'before' },
            'ARS': { symbol: '$', decimals: 2, symbolPosition: 'before' },
            'CLP': { symbol: '$', decimals: 0, symbolPosition: 'before' },
            'COP': { symbol: '$', decimals: 0, symbolPosition: 'before' },
            'PEN': { symbol: 'S/', decimals: 2, symbolPosition: 'before' },
            'PLN': { symbol: 'zł', decimals: 2, symbolPosition: 'after' },
            'CZK': { symbol: 'Kč', decimals: 2, symbolPosition: 'after' },
            'HUF': { symbol: 'Ft', decimals: 0, symbolPosition: 'after' },
            'RON': { symbol: 'lei', decimals: 2, symbolPosition: 'after' },
            'RUB': { symbol: '₽', decimals: 2, symbolPosition: 'after' },
            'UAH': { symbol: '₴', decimals: 2, symbolPosition: 'before' }
        };
        const rules = currencyRules[currencyCode];
        if (!rules) {
            throw new Error(`Unsupported currency: ${currencyCode}`);
        }
        const formattedNumber = amount.toLocaleString('en-US', {
            minimumFractionDigits: rules.decimals,
            maximumFractionDigits: rules.decimals,
            useGrouping: true
        });
        if (rules.symbolPosition === 'before') {
            return `${rules.symbol}${formattedNumber}`;
        }
        else {
            return `${formattedNumber} ${rules.symbol}`;
        }
    }
    formatJobResponse(job) {
        if (!job) {
            return null;
        }
        return {
            ...job,
            formattedSalary: this.formatSalaryDisplay(job.minSalary, job.maxSalary, job.currency, job.salaryDuration),
            salaryRange: job.salaryRange || this.formatSalaryDisplay(job.minSalary, job.maxSalary, job.currency, job.salaryDuration) || 'Not specified'
        };
    }
};
exports.JobsService = JobsService;
exports.JobsService = JobsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(job_entity_1.JobEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(application_entity_1.ApplicationEntity)),
    __param(2, (0, typeorm_1.InjectRepository)(user_entity_1.UserEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], JobsService);
//# sourceMappingURL=jobs.service.js.map