import { Repository } from 'typeorm';
import { JobEntity } from './job.entity';
import { ApplicationEntity } from './application.entity';
import { UserEntity } from '../users/user.entity';
import { CreateJobDto } from './dto/create-job.dto';
import { UpdateJobDto } from './dto/update-job.dto';
export declare class JobsService {
    private readonly jobRepo;
    private readonly applicationRepo;
    private readonly userRepo;
    constructor(jobRepo: Repository<JobEntity>, applicationRepo: Repository<ApplicationEntity>, userRepo: Repository<UserEntity>);
    findAll(filters?: {
        search?: string;
        location?: string;
        jobType?: string;
        companyId?: string;
    }): Promise<any[]>;
    findOne(id: string): Promise<any>;
    create(dto: CreateJobDto, companyId: string): Promise<any>;
    update(id: string, updateJobDto: UpdateJobDto): Promise<any>;
    remove(id: string): Promise<import("typeorm").DeleteResult>;
    applyToJob(jobId: string, applicantId: string, cvUrl: string, coverLetter?: string): Promise<ApplicationEntity>;
    getUserApplications(userId: string): Promise<ApplicationEntity[]>;
    getJobApplications(jobId: string): Promise<ApplicationEntity[]>;
    updateApplicationStatus(applicationId: string, status: 'pending' | 'reviewed' | 'accepted' | 'rejected'): Promise<ApplicationEntity>;
    private formatSalaryDisplay;
    private formatCurrency;
    private formatJobResponse;
}
