"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobEntity = void 0;
const typeorm_1 = require("typeorm");
const user_entity_1 = require("../users/user.entity");
const application_entity_1 = require("./application.entity");
let JobEntity = class JobEntity {
};
exports.JobEntity = JobEntity;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], JobEntity.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], JobEntity.prototype, "title", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text' }),
    __metadata("design:type", String)
], JobEntity.prototype, "description", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], JobEntity.prototype, "location", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], JobEntity.prototype, "salaryRange", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 10, scale: 2, nullable: true }),
    __metadata("design:type", Number)
], JobEntity.prototype, "minSalary", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 10, scale: 2, nullable: true }),
    __metadata("design:type", Number)
], JobEntity.prototype, "maxSalary", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        enum: [
            'USD', 'EUR', 'GBP', 'JPY', 'CHF',
            'CAD', 'MXN',
            'AUD', 'NZD',
            'SEK', 'NOK', 'DKK',
            'ZAR', 'NGN', 'EGP', 'KES', 'GHS', 'MAD', 'TND', 'ETB', 'UGX', 'TZS', 'BWP', 'MUR', 'XOF', 'XAF',
            'CNY', 'INR', 'KRW', 'SGD', 'HKD', 'THB', 'MYR', 'IDR', 'PHP', 'VND',
            'AED', 'SAR', 'QAR', 'KWD', 'BHD', 'OMR', 'ILS', 'TRY',
            'BRL', 'ARS', 'CLP', 'COP', 'PEN',
            'PLN', 'CZK', 'HUF', 'RON', 'RUB', 'UAH'
        ],
        nullable: true
    }),
    __metadata("design:type", String)
], JobEntity.prototype, "currency", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        enum: ['hourly', 'daily', 'weekly', 'monthly', 'annually'],
        nullable: true
    }),
    __metadata("design:type", String)
], JobEntity.prototype, "salaryDuration", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: ['full-time', 'part-time', 'contract', 'internship'] }),
    __metadata("design:type", String)
], JobEntity.prototype, "jobType", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text' }),
    __metadata("design:type", String)
], JobEntity.prototype, "requirements", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UserEntity, { eager: true }),
    __metadata("design:type", user_entity_1.UserEntity)
], JobEntity.prototype, "company", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => application_entity_1.ApplicationEntity, app => app.job),
    __metadata("design:type", Array)
], JobEntity.prototype, "applications", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: true }),
    __metadata("design:type", Boolean)
], JobEntity.prototype, "isActive", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], JobEntity.prototype, "postedDate", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], JobEntity.prototype, "updatedAt", void 0);
exports.JobEntity = JobEntity = __decorate([
    (0, typeorm_1.Entity)('jobs')
], JobEntity);
//# sourceMappingURL=job.entity.js.map