"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IsSalaryRangeValid = IsSalaryRangeValid;
const class_validator_1 = require("class-validator");
function IsSalaryRangeValid(validationOptions) {
    return function (object, propertyName) {
        (0, class_validator_1.registerDecorator)({
            name: 'isSalaryRangeValid',
            target: object.constructor,
            propertyName: propertyName,
            options: validationOptions,
            validator: {
                validate(value, args) {
                    const obj = args.object;
                    const minSalary = obj.minSalary;
                    const maxSalary = obj.maxSalary;
                    if (minSalary !== undefined && maxSalary !== undefined) {
                        return minSalary <= maxSalary;
                    }
                    return true;
                },
                defaultMessage(args) {
                    return 'Maximum salary must be greater than or equal to minimum salary';
                },
            },
        });
    };
}
//# sourceMappingURL=salary-range.validator.js.map