"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardController = void 0;
const common_1 = require("@nestjs/common");
const jwt_auth_guard_1 = require("../auth/jwt-auth.guard");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const connection_entity_1 = require("../network/connection.entity");
const job_entity_1 = require("../jobs/job.entity");
const vessel_entity_1 = require("../vessels/vessel.entity");
const message_entity_1 = require("../messages/message.entity");
const post_entity_1 = require("../posts/post.entity");
let DashboardController = class DashboardController {
    constructor(connections, jobs, vessels, messages, posts) {
        this.connections = connections;
        this.jobs = jobs;
        this.vessels = vessels;
        this.messages = messages;
        this.posts = posts;
    }
    async getDashboardData() {
        const [connections, jobs, vessels, messages] = await Promise.all([
            this.connections.count(),
            this.jobs.count(),
            this.vessels.count(),
            this.messages.count()
        ]);
        const feed = await this.posts.find({ order: { createdAt: 'DESC' }, take: 10 });
        return {
            stats: { connections, jobs, vessels, messages },
            feed
        };
    }
};
exports.DashboardController = DashboardController;
__decorate([
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], DashboardController.prototype, "getDashboardData", null);
exports.DashboardController = DashboardController = __decorate([
    (0, common_1.Controller)('dashboard'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, typeorm_1.InjectRepository)(connection_entity_1.ConnectionEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(job_entity_1.JobEntity)),
    __param(2, (0, typeorm_1.InjectRepository)(vessel_entity_1.VesselEntity)),
    __param(3, (0, typeorm_1.InjectRepository)(message_entity_1.MessageEntity)),
    __param(4, (0, typeorm_1.InjectRepository)(post_entity_1.PostEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], DashboardController);
//# sourceMappingURL=dashboard.controller.js.map