import { Repository } from 'typeorm';
import { ConnectionEntity } from '../network/connection.entity';
import { JobEntity } from '../jobs/job.entity';
import { VesselEntity } from '../vessels/vessel.entity';
import { MessageEntity } from '../messages/message.entity';
import { PostEntity } from '../posts/post.entity';
export declare class DashboardController {
    private readonly connections;
    private readonly jobs;
    private readonly vessels;
    private readonly messages;
    private readonly posts;
    constructor(connections: Repository<ConnectionEntity>, jobs: Repository<JobEntity>, vessels: Repository<VesselEntity>, messages: Repository<MessageEntity>, posts: Repository<PostEntity>);
    getDashboardData(): Promise<{
        stats: {
            connections: number;
            jobs: number;
            vessels: number;
            messages: number;
        };
        feed: PostEntity[];
    }>;
}
