import { AuthService } from './auth.service';
import { LoginDto } from './dto/login.dto';
import { RegisterDto } from './dto/register.dto';
import { VerifyEmailDto } from './dto/verify-email.dto';
import { ForgotPasswordDto } from './dto/forgot-password.dto';
import { ResetPasswordDto } from './dto/reset-password.dto';
import { ResendOtpDto } from './dto/resend-otp.dto';
export declare class AuthController {
    private readonly authService;
    constructor(authService: AuthService);
    login(dto: LoginDto): Promise<{
        user: {
            id: string | undefined;
            email: string;
            name: string;
            userType: "professional" | "company";
            isEmailVerified: boolean;
        };
        token: string;
    }>;
    register(dto: RegisterDto): Promise<{
        user: {
            id: string;
            email: string;
            name: string;
            userType: "professional" | "company";
            isEmailVerified: boolean;
        };
        message: string;
    }>;
    verifyEmail(dto: VerifyEmailDto): Promise<{
        user: {
            id: string;
            email: string;
            name: string;
            userType: "professional" | "company";
            isEmailVerified: boolean;
        };
        token: string;
        message: string;
    }>;
    resendVerificationOtp(dto: ResendOtpDto): Promise<{
        message: string;
    }>;
    forgotPassword(dto: ForgotPasswordDto): Promise<{
        message: string;
    }>;
    resetPassword(dto: ResetPasswordDto): Promise<{
        message: string;
    }>;
}
