"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddSalaryFields1700000000000 = void 0;
const typeorm_1 = require("typeorm");
class AddSalaryFields1700000000000 {
    constructor() {
        this.name = 'AddSalaryFields1700000000000';
    }
    async up(queryRunner) {
        await queryRunner.changeColumn('jobs', 'salaryRange', new typeorm_1.TableColumn({
            name: 'salaryRange',
            type: 'varchar',
            isNullable: true,
        }));
        await queryRunner.addColumn('jobs', new typeorm_1.TableColumn({
            name: 'minSalary',
            type: 'decimal',
            precision: 10,
            scale: 2,
            isNullable: true,
        }));
        await queryRunner.addColumn('jobs', new typeorm_1.TableColumn({
            name: 'maxSalary',
            type: 'decimal',
            precision: 10,
            scale: 2,
            isNullable: true,
        }));
        await queryRunner.addColumn('jobs', new typeorm_1.TableColumn({
            name: 'currency',
            type: 'enum',
            enum: ['USD', 'EUR', 'GBP', 'CAD', 'AUD', 'JPY', 'CHF', 'SEK', 'NOK', 'DKK'],
            isNullable: true,
        }));
        await queryRunner.addColumn('jobs', new typeorm_1.TableColumn({
            name: 'salaryDuration',
            type: 'enum',
            enum: ['hourly', 'daily', 'weekly', 'monthly', 'annually'],
            isNullable: true,
        }));
    }
    async down(queryRunner) {
        await queryRunner.dropColumn('jobs', 'salaryDuration');
        await queryRunner.dropColumn('jobs', 'currency');
        await queryRunner.dropColumn('jobs', 'maxSalary');
        await queryRunner.dropColumn('jobs', 'minSalary');
        await queryRunner.changeColumn('jobs', 'salaryRange', new typeorm_1.TableColumn({
            name: 'salaryRange',
            type: 'varchar',
            isNullable: false,
        }));
    }
}
exports.AddSalaryFields1700000000000 = AddSalaryFields1700000000000;
//# sourceMappingURL=1700000000000-AddSalaryFields.js.map