# EmailJS Setup Guide

This application uses EmailJS for sending emails. Follow these steps to configure EmailJS:

## 1. Create EmailJS Account

1. Go to [EmailJS](https://www.emailjs.com/)
2. Sign up for a free account
3. Verify your email address

## 2. Create Email Service

1. In your EmailJS dashboard, go to "Email Services"
2. Click "Add New Service"
3. Choose your email provider (Gmail, Outlook, etc.)
4. Follow the setup instructions for your provider
5. Note down your **Service ID**

## 3. Create Email Templates

### Verification Email Template

1. Go to "Email Templates" in your dashboard
2. Click "Create New Template"
3. Use this template for email verification:

**Template Name:** Email Verification
**Template ID:** template_verification

**Subject:** Verify Your Email - {{app_name}}

**Content:**
```html
<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
  <div style="text-align: center; margin-bottom: 30px;">
    <h1 style="color: #0077B5;">{{app_name}}</h1>
    <h2 style="color: #333;">Verify Your Email Address</h2>
  </div>
  
  <div style="background-color: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
    <p>Hello {{to_name}},</p>
    <p>Thank you for registering with {{app_name}}! To complete your registration, please use the verification code below:</p>
    
    <div style="text-align: center; margin: 30px 0;">
      <div style="background-color: #0077B5; color: white; padding: 15px 30px; border-radius: 8px; font-size: 24px; font-weight: bold; letter-spacing: 3px; display: inline-block;">
        {{otp_code}}
      </div>
    </div>
    
    <p><strong>This code will expire in {{expires_in}}.</strong></p>
    <p>If you didn't create an account with us, please ignore this email.</p>
  </div>
  
  <div style="text-align: center; color: #666; font-size: 12px;">
    <p>Need help? Contact us at {{support_email}}</p>
    <p>&copy; 2024 {{app_name}}. All rights reserved.</p>
  </div>
</div>
```

### Password Reset Template

1. Create another template for password reset
**Template Name:** Password Reset
**Template ID:** template_reset

**Subject:** Reset Your Password - {{app_name}}

**Content:**
```html
<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
  <div style="text-align: center; margin-bottom: 30px;">
    <h1 style="color: #0077B5;">{{app_name}}</h1>
    <h2 style="color: #333;">Reset Your Password</h2>
  </div>
  
  <div style="background-color: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
    <p>Hello {{to_name}},</p>
    <p>We received a request to reset your password. Use the code below to reset your password:</p>
    
    <div style="text-align: center; margin: 30px 0;">
      <div style="background-color: #dc3545; color: white; padding: 15px 30px; border-radius: 8px; font-size: 24px; font-weight: bold; letter-spacing: 3px; display: inline-block;">
        {{otp_code}}
      </div>
    </div>
    
    <p><strong>This code will expire in {{expires_in}}.</strong></p>
    <p>If you didn't request a password reset, please ignore this email or contact support if you have concerns.</p>
  </div>
  
  <div style="text-align: center; color: #666; font-size: 12px;">
    <p>Need help? Contact us at {{support_email}}</p>
    <p>&copy; 2024 {{app_name}}. All rights reserved.</p>
  </div>
</div>
```

## 4. Get Your Keys

1. Go to "Account" in your EmailJS dashboard
2. Note down your **Public Key**
3. Generate and note down your **Private Key**

## 5. Environment Variables

Add these environment variables to your `.env` file:

```env
# EmailJS Configuration
EMAILJS_SERVICE_ID=your_service_id_here
EMAILJS_PUBLIC_KEY=your_public_key_here
EMAILJS_PRIVATE_KEY=your_private_key_here
EMAILJS_VERIFICATION_TEMPLATE_ID=template_verification
EMAILJS_RESET_TEMPLATE_ID=template_reset
```

## 6. Template Variables

Make sure your EmailJS templates include these variables:

### For both templates:
- `{{to_email}}` - Recipient email
- `{{to_name}}` - Recipient name (extracted from email)
- `{{otp_code}}` - The 6-digit verification code
- `{{app_name}}` - Application name
- `{{expires_in}}` - Expiration time
- `{{support_email}}` - Support email address

## 7. Testing

1. Start your backend server
2. Try registering a new user
3. Check the server logs for the OTP code
4. Check your email for the verification message

## Troubleshooting

- **Emails not sending**: Check your service configuration and API keys
- **Template not found**: Verify template IDs match your environment variables
- **Rate limiting**: EmailJS has rate limits on free accounts
- **Spam folder**: Check recipient's spam folder

## Production Considerations

- Use environment variables for all sensitive data
- Monitor EmailJS usage and upgrade plan if needed
- Set up proper error handling and logging
- Consider implementing email delivery status tracking